extends Node2D
class_name Viseur

@export var rendu_ligne : Line2D
@export var longueur_vision : float = 100.0
@export var ligne_de_mire : RayCast2D
var voit_la_cible := false
@export var color_tracking :Color
@export var color_not_tracking :Color

func _ready():
    assert(rendu_ligne.points.size() >= 2)
    ligne_de_mire.target_position = Vector2(longueur_vision,0.0)
    rendu_ligne.points[1] = Vector2(longueur_vision,0.0)

func _physics_process(_delta: float) -> void:
    voit_la_cible = false
    rendu_ligne.points[1].x = longueur_vision
    if ligne_de_mire.is_colliding():
        voit_la_cible = ligne_de_mire.get_collider() is BlueGuyArea
        rendu_ligne.points[1].x = (ligne_de_mire.get_collision_point() - rendu_ligne.global_position).length()
    rendu_ligne.modulate = color_tracking if voit_la_cible else color_not_tracking