extends Node2D


@export var animation_tourette :AnimatedSprite2D
@export var tournage_tourette : Rotation
@export var traquage_tourette : Traqueur
@export var tirreur : Shooter
@export var viseurs: Array[Viseur]
var voit_la_cible : bool = false

func _physics_process(_delta: float) -> void:
	var etat_precedent := voit_la_cible
	voit_la_cible = false
	for v in viseurs:
		voit_la_cible = voit_la_cible || v.voit_la_cible

	if etat_precedent != voit_la_cible:
		tournage_tourette.active = not voit_la_cible
		traquage_tourette.active = voit_la_cible
		animation_tourette.play( "Fire" if voit_la_cible else "Idle")
		if voit_la_cible:
			tirreur.start()
		else:
			tirreur.stop()
