extends Node2D

@export var source: Node2D
@export var viseur: Line2D
@export var timerLignDeMire: Timer
@export var distance_tir: float = 1000.

var _is_shooting := false

func _ready():
    timerLignDeMire.timeout.connect(_on_end_display_ligne_de_mire)

func _process(_delta: float) -> void:
    _is_shooting = Input.is_action_just_pressed("CliqueSouris")
    if _is_shooting:
        var pos_souris := get_global_mouse_position()
        var pos_source := source.global_position
        var destination_vers_souris = pos_souris - pos_source
        viseur.points[1] = destination_vers_souris
        timerLignDeMire.start()

func _physics_process(_delta: float) -> void:
    if _is_shooting && viseur.points[1].length_squared() > 0.0:
        viseur.visible = true
        var position_fin_tir := viseur.points[1].normalized() * distance_tir
        viseur.points[1] = position_fin_tir
        _is_shooting = false

        var query:PhysicsRayQueryParameters2D = PhysicsRayQueryParameters2D.new()
        query.from = source.global_position
        query.to = viseur.points[1]
        query.collision_mask = 0b10
        query.exclude = [source]
        var collision_hit :Dictionary= get_world_2d().direct_space_state.intersect_ray(query)

        if collision_hit:
            viseur.points[1] = collision_hit.position - source.global_position

func _on_end_display_ligne_de_mire():
    viseur.visible = false