extends Node2D
class_name Shooter

@export var TurretProjectile :PackedScene
@export var tireur : Node2D
@export var cible : Node2D
@export var timer : Timer
@export var active : bool = false

#TODO: trouver une meilleure solution
@onready var projectile_parent := $/root/Niveau/Projectiles

func _ready():
    assert(projectile_parent)
    assert(timer)
    timer.timeout.connect(_fire)

func _fire():
    var delta_position := cible.global_position - tireur.global_position
    var proj = TurretProjectile.instantiate()
    proj.fire(delta_position.normalized())
    proj.global_position = tireur.global_position
    projectile_parent.add_child(proj)

func start():
    timer.start()

func stop():
    timer.stop()
